using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Resources;
using Microsoft.ContentManagement.Publishing;

namespace ContosoNet.Content_Templates
{
	/// <summary>
	/// Summary description for BaseTemplate.
	/// </summary>
	public class PressReleaseDocument : System.Web.UI.Page
	{
		protected Microsoft.ContentManagement.WebControls.RobotMetaTag RobotMetaTag1;
		protected Microsoft.ContentManagement.WebControls.HtmlPlaceholderControl TitlePlaceholder;
		protected Microsoft.ContentManagement.WebControls.HtmlPlaceholderControl AbstractPlaceholder;
		protected Telerik.WebControls.RadEditorPlaceHolderControl EmployeeNotesPlaceholder;
		protected System.Web.UI.WebControls.Label QuoteLabel;
		protected System.Web.UI.WebControls.Label AttributionLabel;
		protected System.Web.UI.WebControls.Label EmployeeNotesLabel;
		protected Microsoft.ContentManagement.SharePoint.WebControls.SharePointDocumentPlaceholderControl BodyPlaceholder;
	
		protected LocalizationManager localizationManager;

		private void Page_Load(object sender, System.EventArgs e)
		{
			// Localize the page
			localizationManager = new LocalizationManager ();
			QuoteLabel.Text = localizationManager.GetString ("pressReleaseQuote");
			AttributionLabel.Text = localizationManager.GetString ("pressReleaseAttribution");
			EmployeeNotesLabel.Text = localizationManager.GetString ("employeeNotesLabel");

			// Hide "Employee Notes" from casual browsers
			if (Microsoft.ContentManagement.WebControls.WebAuthorContext.Current.Mode ==
				Microsoft.ContentManagement.WebControls.WebAuthorContextMode.PresentationPublished)
			{
				EmployeeNotesLabel.Visible = false;
				EmployeeNotesPlaceholder.Visible = false;
			}
			else
			{
				EmployeeNotesLabel.Visible = true;
				EmployeeNotesPlaceholder.Visible = true;
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
